/*
 * Decompiled with CFR 0.152.
 */
package jemu.util.hexeditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.NumberFormat;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import jemu.system.cpc.CPC;
import jemu.util.hexeditor.Data;
import jemu.util.hexeditor.Text;
import jemu.util.hexeditor.User;

public class HexEditor
extends JInternalFrame {
    static String savename;
    static final int BUFFER_SIZE = 65536;
    static final int BYTE_MASK = 255;
    static final String[] DUMP_WIDTHS;
    static final String EMPTY_STATUS = " ";
    static final char FIRST_CHAR = ' ';
    static final boolean FREE_VERSION = true;
    static final char[] HEX_DIGITS;
    static final int HEX_IGNORE = -1;
    static final int HEX_INVALID = -2;
    static final char LAST_CHAR = '~';
    static final char MARKER_CHAR = '|';
    static final String MARKER_STRING;
    static final int NIBBLE_MASK = 15;
    static final int NIBBLE_SHIFT = 4;
    static final int OFFSET_DIGITS = 8;
    static final String PROGRAM_TITLE = "JavaCPC Hex Editor";
    static final char REPLACE_CHAR = '.';
    static final Insets TEXT_MARGINS;
    static String clipString;
    static int dumpWidth;
    static JComboBox dumpWidthDialog;
    static String fontName;
    static JComboBox fontNameDialog;
    static NumberFormat formatComma;
    static JButton menuButton;
    static JMenuItem menuCopyDump;
    static JMenuItem menuCopyHex;
    static JMenuItem menuCopyText;
    static JMenuItem menuDelete;
    static JMenuItem menuFind;
    static JMenuItem menuNext;
    static JMenuItem menuPasteHex;
    static JMenuItem menuPasteText;
    static JMenuItem menuReplace;
    static JMenuItem menuSelect;
    static JPopupMenu menuPopup;
    static int nibbleCount;
    static Data nibbleData;
    static JButton openButton;
    static JButton dumpButton;
    static JCheckBox overDialog;
    static boolean overFlag;
    static JButton saveButton;
    static JCheckBox searchByteBound;
    static JCheckBox searchIgnoreNulls;
    static JButton searchCloseButton;
    static JButton searchFindButton;
    static JButton searchNextButton;
    static JButton searchReplaceButton;
    static JDialog searchDialog;
    static JTextField searchFindText;
    static JTextField searchReplaceText;
    static JRadioButton searchIsHex;
    static JRadioButton searchIsText;
    static JLabel searchStatus;
    static Text textPanel;
    static JScrollBar textScroll;
    static ActionListener userActions;

    public HexEditor() {
        clipString = null;
        dumpWidth = 16;
        String fileName = "";
        fontName = "Monospaced";
        boolean maximizeFlag = false;
        nibbleCount = 0;
        nibbleData = new Data(0);
        overFlag = true;
        searchDialog = null;
        formatComma = NumberFormat.getInstance();
        formatComma.setGroupingUsed(true);
        userActions = new User();
        Box panel1 = Box.createVerticalBox();
        panel1.add(Box.createVerticalStrut(15));
        JPanel panel2 = new JPanel(new FlowLayout(1, 40, 0));
        menuButton = new JButton("Edit Menu");
        menuButton.addActionListener(userActions);
        menuButton.setMnemonic(77);
        panel2.add(menuButton);
        openButton = new JButton("Open File...");
        openButton.addActionListener(userActions);
        openButton.setMnemonic(79);
        panel2.add(openButton);
        dumpButton = new JButton("Dump ram");
        dumpButton.addActionListener(userActions);
        dumpButton.setMnemonic(79);
        panel2.add(dumpButton);
        saveButton = new JButton("Save File...");
        saveButton.addActionListener(userActions);
        saveButton.setMnemonic(83);
        panel2.add(saveButton);
        panel1.add(panel2);
        panel1.add(Box.createVerticalStrut(13));
        menuPopup = new JPopupMenu();
        menuCopyDump = new JMenuItem("Copy Dump");
        menuCopyDump.addActionListener(userActions);
        menuPopup.add(menuCopyDump);
        menuCopyHex = new JMenuItem("Copy Hex");
        menuCopyHex.addActionListener(userActions);
        menuPopup.add(menuCopyHex);
        menuCopyText = new JMenuItem("Copy Text");
        menuCopyText.addActionListener(userActions);
        menuPopup.add(menuCopyText);
        menuPasteHex = new JMenuItem("Paste Hex");
        menuPasteHex.addActionListener(userActions);
        menuPopup.add(menuPasteHex);
        menuPasteText = new JMenuItem("Paste Text");
        menuPasteText.addActionListener(userActions);
        menuPopup.add(menuPasteText);
        menuPopup.addSeparator();
        menuFind = new JMenuItem("Find...");
        menuFind.addActionListener(userActions);
        menuFind.setMnemonic(70);
        menuPopup.add(menuFind);
        menuNext = new JMenuItem("Find Next");
        menuNext.addActionListener(userActions);
        menuNext.setMnemonic(78);
        menuPopup.add(menuNext);
        menuReplace = new JMenuItem("Replace");
        menuReplace.addActionListener(userActions);
        menuReplace.setMnemonic(82);
        menuPopup.add(menuReplace);
        menuPopup.addSeparator();
        menuDelete = new JMenuItem("Delete");
        menuDelete.addActionListener(userActions);
        menuDelete.setMnemonic(68);
        menuPopup.add(menuDelete);
        menuSelect = new JMenuItem("Select All");
        menuSelect.addActionListener(userActions);
        menuSelect.setMnemonic(65);
        menuPopup.add(menuSelect);
        JPanel panel3 = new JPanel(new FlowLayout(1, 5, 0));
        panel3.add(Box.createHorizontalStrut(30));
        dumpWidthDialog = new JComboBox<String>(DUMP_WIDTHS);
        dumpWidthDialog.setEditable(false);
        dumpWidthDialog.setSelectedItem(String.valueOf(dumpWidth));
        dumpWidthDialog.addActionListener(userActions);
        panel3.add(dumpWidthDialog);
        panel3.add(new JLabel("bytes per line"));
        panel3.add(Box.createHorizontalStrut(20));
        overDialog = new JCheckBox("overwrite mode", overFlag);
        overDialog.addActionListener(userActions);
        overDialog.setEnabled(true);
        panel3.add(overDialog);
        panel1.add(panel3);
        panel1.add(Box.createVerticalStrut(7));
        JPanel panel4 = new JPanel(new FlowLayout(1, 0, 0));
        panel4.add(panel1);
        textPanel = new Text();
        textScroll = new JScrollBar(1, 0, 1, 0, 1);
        textScroll.setEnabled(true);
        textScroll.getModel().addChangeListener(textPanel);
        Container panel6 = this.getContentPane();
        panel6.setLayout(new BorderLayout(5, 5));
        panel6.add((Component)panel4, "North");
        panel6.add((Component)textPanel, "Center");
        panel6.add((Component)textScroll, "East");
        this.setLocation(50, 50);
        this.setSize(700, 500);
        this.validate();
        if (fileName.length() > 0) {
            HexEditor.openFile(new File(fileName));
        } else {
            byte[] array = PROGRAM_TITLE.getBytes();
            nibbleCount = array.length * 2;
            nibbleData = new Data(nibbleCount);
            for (int i = 0; i < array.length; ++i) {
                nibbleData.append(array[i] >> 4 & 0xF);
                nibbleData.append(array[i] & 0xF);
            }
        }
        textPanel.beginFile();
        this.setVisible(true);
    }

    static boolean canWriteFile(File givenFile) {
        boolean result;
        if (givenFile.isDirectory()) {
            JOptionPane.showMessageDialog(new Frame(), givenFile.getName() + " is a directory or folder.\nPlease select a normal file.");
            result = false;
        } else if (givenFile.isHidden()) {
            JOptionPane.showMessageDialog(new Frame(), givenFile.getName() + " is a hidden or protected file.\nPlease select a normal file.");
            result = false;
        } else if (!givenFile.isFile()) {
            result = true;
        } else if (givenFile.canWrite()) {
            result = true;
        } else {
            JOptionPane.showMessageDialog(new Frame(), givenFile.getName() + " is locked or write protected.\nCan't write to this file.");
            result = false;
        }
        return result;
    }

    static int charHexValue(char ch) {
        int result = ch >= '0' && ch <= '9' ? ch - 48 : (ch >= 'A' && ch <= 'F' ? ch - 65 + 10 : (ch >= 'a' && ch <= 'f' ? ch - 97 + 10 : (ch == ',' || ch == '.' || ch == ':' ? -1 : (Character.isWhitespace(ch) ? -1 : -2))));
        return result;
    }

    static void copyDump() {
        int endIndex;
        int beginIndex = Math.min(HexEditor.textPanel.cursorDot, HexEditor.textPanel.cursorMark);
        if (beginIndex < (endIndex = Math.max(HexEditor.textPanel.cursorDot, HexEditor.textPanel.cursorMark))) {
            int lineLength = 8 + 4 * dumpWidth + 5;
            StringBuffer lineBuffer = new StringBuffer(lineLength + 1);
            lineBuffer.setLength(lineLength + 1);
            lineBuffer.setCharAt(lineLength, '\n');
            int lineNibbles = 2 * dumpWidth;
            int lineUsed = -1;
            int nextText = -1;
            int nextHex = -1;
            String result = "";
            for (int thisIndex = beginIndex; thisIndex < endIndex; ++thisIndex) {
                if (lineUsed >= lineNibbles) {
                    result = result + lineBuffer.toString();
                    lineUsed = -1;
                }
                if (lineUsed < 0) {
                    for (int i = 0; i < lineLength; ++i) {
                        lineBuffer.setCharAt(i, ' ');
                    }
                    lineBuffer.setCharAt(lineLength - dumpWidth - 2, '|');
                    lineBuffer.setCharAt(lineLength - 1, '|');
                    int shiftedOffset = thisIndex / lineNibbles * dumpWidth;
                    for (int i = 7; i >= 0; --i) {
                        lineBuffer.setCharAt(i, HEX_DIGITS[shiftedOffset & 0xF]);
                        shiftedOffset >>= 4;
                    }
                    lineUsed = thisIndex % lineNibbles;
                    nextHex = lineUsed + lineUsed / 2 + 8 + 2;
                    nextText = lineLength - dumpWidth - 1 + lineUsed / 2;
                }
                lineBuffer.setCharAt(nextHex++, HEX_DIGITS[nibbleData.get(thisIndex)]);
                nextHex += thisIndex % 2;
                ++lineUsed;
                if (thisIndex % 2 == 1) {
                    int byteValue;
                    if (thisIndex - 1 < beginIndex) {
                        byteValue = 46;
                    } else {
                        byteValue = nibbleData.get(thisIndex - 1) << 4 | nibbleData.get(thisIndex);
                        if (byteValue < 32 || byteValue > 126) {
                            byteValue = 46;
                        }
                    }
                    lineBuffer.setCharAt(nextText++, (char)byteValue);
                    continue;
                }
                if (thisIndex + 1 < endIndex) continue;
                lineBuffer.setCharAt(nextText++, '.');
            }
            result = result + lineBuffer.toString();
            HexEditor.setClipboard(result);
        }
    }

    static void copyHex() {
        int endIndex;
        int beginIndex = Math.min(HexEditor.textPanel.cursorDot, HexEditor.textPanel.cursorMark);
        if (beginIndex < (endIndex = Math.max(HexEditor.textPanel.cursorDot, HexEditor.textPanel.cursorMark))) {
            String result = "";
            for (int thisIndex = beginIndex; thisIndex < endIndex; ++thisIndex) {
                result = result + HEX_DIGITS[nibbleData.get(thisIndex)];
            }
            HexEditor.setClipboard(result);
        }
    }

    static void copyText() {
        int endIndex;
        int beginIndex = Math.min(HexEditor.textPanel.cursorDot, HexEditor.textPanel.cursorMark);
        if (beginIndex < (endIndex = Math.max(HexEditor.textPanel.cursorDot, HexEditor.textPanel.cursorMark))) {
            byte[] array = new byte[(endIndex - beginIndex + 1) / 2];
            int thisIndex = beginIndex;
            for (int i = 0; i < array.length; ++i) {
                int byteValue = nibbleData.get(thisIndex++) << 4;
                if (thisIndex < endIndex) {
                    byteValue |= nibbleData.get(thisIndex++);
                }
                array[i] = (byte)byteValue;
            }
            HexEditor.setClipboard(new String(array));
        }
    }

    static void deleteSelected() {
        int endIndex;
        int beginIndex = Math.min(HexEditor.textPanel.cursorDot, HexEditor.textPanel.cursorMark);
        if (beginIndex < (endIndex = Math.max(HexEditor.textPanel.cursorDot, HexEditor.textPanel.cursorMark))) {
            for (int thisIndex = beginIndex; thisIndex < endIndex; ++thisIndex) {
                nibbleData.delete(beginIndex);
            }
            HexEditor.textPanel.cursorDot = HexEditor.textPanel.cursorMark = beginIndex;
            textPanel.limitCursorRange();
            textPanel.makeVisible(HexEditor.textPanel.cursorDot);
            textPanel.adjustScrollBar();
            textPanel.repaint();
        }
    }

    static String getClipboard() {
        String result;
        try {
            result = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null).getTransferData(DataFlavor.stringFlavor);
        }
        catch (IllegalStateException ise) {
            result = "";
        }
        catch (IOException ioe) {
            result = "";
        }
        catch (UnsupportedFlavorException ufe) {
            result = "";
        }
        return result;
    }

    static void openFile(File givenFile) {
        File inputFile;
        nibbleCount = 0;
        if (givenFile == null) {
            FileDialog filedia = new FileDialog(new Frame(), "Open file...", 0);
            filedia.setVisible(true);
            String filename = filedia.getFile();
            if (filename == null) {
                HexEditor.refreshDataSize();
                return;
            }
            savename = filename = filedia.getDirectory() + filedia.getFile();
            inputFile = new File(savename);
        } else {
            inputFile = givenFile;
        }
        long inputSize = inputFile.length();
        if (inputSize > 0x3FFF0000L) {
            JOptionPane.showMessageDialog(new Frame(), "This program can't open files larger than one gigabyte.\n" + inputFile.getName() + " has " + formatComma.format(inputSize) + " bytes.");
            HexEditor.refreshDataSize();
            return;
        }
        if (inputSize > 99999999L && JOptionPane.showConfirmDialog(new Frame(), "Files larger than 100 megabytes may be slow.\n" + inputFile.getName() + " has " + formatComma.format(inputSize) + " bytes.\nDo you want to open this file anyway?", "Large File Warning", 1) != 0) {
            HexEditor.refreshDataSize();
            return;
        }
        try {
            int length;
            byte[] buffer = new byte[65536];
            FileInputStream inputStream = new FileInputStream(inputFile);
            nibbleData = new Data(2 * (int)inputSize);
            while ((length = inputStream.read(buffer, 0, 65536)) > 0) {
                for (int i = 0; i < length; ++i) {
                    nibbleData.append(buffer[i] >> 4 & 0xF);
                    nibbleData.append(buffer[i] & 0xF);
                }
            }
            inputStream.close();
        }
        catch (IOException ioe) {
            nibbleData = new Data(0);
            JOptionPane.showMessageDialog(new Frame(), "Can't read from input file:\n" + ioe.getMessage());
        }
        catch (OutOfMemoryError oome) {
            nibbleData = new Data(0);
            JOptionPane.showMessageDialog(new Frame(), "Not enough memory to open this file.\n" + inputFile.getName() + " has " + formatComma.format(inputSize) + " bytes.\nTry increasing the Java heap size with the -Xmx option.");
        }
        HexEditor.refreshDataSize();
    }

    static void pasteHex() {
        String text = HexEditor.getClipboard();
        int length = text.length();
        int[] nibbles = new int[length * 2];
        int used = 0;
        for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            int hexValue = HexEditor.charHexValue(ch);
            if (hexValue >= 0) {
                nibbles[used++] = hexValue;
                continue;
            }
            if (hexValue == -1) continue;
            JOptionPane.showMessageDialog(new Frame(), "Clipboard string must be hexadecimal digits or spaces; found " + (Character.isISOControl(ch) ? "" : "\"" + ch + "\" or ") + "0x" + Integer.toHexString(ch).toUpperCase() + ".");
            return;
        }
        HexEditor.pasteNibbles(nibbles, used);
    }

    static void pasteNibbles(int[] array, int used) {
        if (used <= 0) {
            return;
        }
        if (overFlag) {
            int endIndex;
            int beginIndex = Math.min(HexEditor.textPanel.cursorDot, HexEditor.textPanel.cursorMark);
            if (beginIndex < (endIndex = Math.max(HexEditor.textPanel.cursorDot, HexEditor.textPanel.cursorMark)) && used != endIndex - beginIndex) {
                JOptionPane.showMessageDialog(new Frame(), "Overwrite selection (" + (endIndex - beginIndex) + ") and clipboard (" + used + ") have different sizes.");
                return;
            }
            HexEditor.textPanel.cursorDot = beginIndex;
            for (int i = 0; i < used; ++i) {
                nibbleData.put(HexEditor.textPanel.cursorDot++, array[i]);
            }
        } else {
            HexEditor.deleteSelected();
            for (int i = 0; i < used; ++i) {
                nibbleData.insert(HexEditor.textPanel.cursorDot++, array[i]);
            }
        }
        HexEditor.textPanel.cursorMark = HexEditor.textPanel.cursorDot;
        textPanel.limitCursorRange();
        textPanel.makeVisible(HexEditor.textPanel.cursorDot);
        textPanel.adjustScrollBar();
        textPanel.repaint();
    }

    static void pasteText() {
        byte[] bytes = HexEditor.getClipboard().getBytes();
        int[] nibbles = new int[bytes.length * 2];
        int used = 0;
        for (int i = 0; i < bytes.length; ++i) {
            nibbles[used++] = bytes[i] >> 4 & 0xF;
            nibbles[used++] = bytes[i] & 0xF;
        }
        HexEditor.pasteNibbles(nibbles, used);
    }

    static void refreshDataSize() {
        nibbleCount = nibbleData.size();
    }

    static void saveFile() {
        FileDialog filedia = new FileDialog(new Frame(), "Save file...", 1);
        filedia.setVisible(true);
        String filename = filedia.getFile();
        if (filename == null) {
            return;
        }
        savename = filename = filedia.getDirectory() + filedia.getFile();
        File outputFile = new File(savename);
        try {
            if (HexEditor.canWriteFile(outputFile)) {
                byte[] buffer = new byte[65536];
                int length = 0;
                FileOutputStream outputStream = new FileOutputStream(outputFile);
                HexEditor.refreshDataSize();
                int i = 0;
                while (i < nibbleCount) {
                    if (length >= 65536) {
                        outputStream.write(buffer);
                        length = 0;
                    }
                    buffer[length] = (byte)(nibbleData.get(i++) << 4);
                    if (i < nibbleCount) {
                        int n = length;
                        buffer[n] = (byte)(buffer[n] | (byte)nibbleData.get(i++));
                    }
                    ++length;
                }
                if (length > 0) {
                    outputStream.write(buffer, 0, length);
                }
                outputStream.close();
            }
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(new Frame(), "Can't write to output file:\n" + ioe.getMessage());
        }
    }

    static int[] searchConvertNibbles(String text, String type) {
        int[] result;
        if (searchIsHex.isSelected()) {
            int i;
            boolean error = false;
            int length = text.length();
            int[] nibbles = new int[length * 2];
            int used = 0;
            for (i = 0; i < length; ++i) {
                char ch = text.charAt(i);
                int hexValue = HexEditor.charHexValue(ch);
                if (hexValue >= 0) {
                    nibbles[used++] = hexValue;
                    continue;
                }
                if (hexValue == -1) continue;
                HexEditor.showSearchMessage("Invalid hex digit in " + type + " string; found " + (Character.isISOControl(ch) ? "" : "\"" + ch + "\" or ") + "0x" + Integer.toHexString(ch).toUpperCase() + ".");
                error = true;
                break;
            }
            if (error) {
                used = 0;
            } else if (used == 0) {
                HexEditor.showSearchMessage("No valid hex digits found in " + type + " string.");
            }
            result = new int[used];
            for (i = 0; i < used; ++i) {
                result[i] = nibbles[i];
            }
        } else {
            byte[] bytes = text.getBytes();
            result = new int[bytes.length * 2];
            int used = 0;
            for (int i = 0; i < bytes.length; ++i) {
                result[used++] = bytes[i] >> 4 & 0xF;
                result[used++] = bytes[i] & 0xF;
            }
        }
        return result;
    }

    static void searchFindFirst() {
        HexEditor.searchFindNext(0);
    }

    static void searchFindNext() {
        HexEditor.searchFindNext(Math.max(HexEditor.textPanel.cursorDot, HexEditor.textPanel.cursorMark));
    }

    static void searchFindNext(int givenStart) {
        if (searchDialog == null) {
            HexEditor.showSearchMessage("There is no search string, no search dialog.");
            return;
        }
        String text = searchFindText.getText();
        if (text.length() == 0) {
            HexEditor.showSearchMessage("Empty strings are found everywhere.  (Joke.)");
            return;
        }
        int[] nibbles = HexEditor.searchConvertNibbles(text, "search");
        if (nibbles.length == 0) {
            return;
        }
        searchStatus.setText(EMPTY_STATUS);
        boolean byteFlag = searchByteBound.isSelected();
        boolean matchFlag = false;
        boolean nullFlag = searchIgnoreNulls.isSelected() && nibbles.length % 2 == 0;
        int start = givenStart;
        if (byteFlag) {
            start += start % 2;
        }
        while (nibbleCount - start >= nibbles.length) {
            boolean differFlag = false;
            for (int i = 0; i < nibbles.length; ++i) {
                if (nibbles[i] == nibbleData.get(start + i)) continue;
                differFlag = true;
                break;
            }
            if (!differFlag) {
                matchFlag = true;
                HexEditor.textPanel.cursorMark = start;
                HexEditor.textPanel.cursorDot = start + nibbles.length;
                break;
            }
            if (nullFlag && start % 2 == 0) {
                int dataIndex = start;
                differFlag = false;
                int findIndex = 0;
                while (dataIndex < nibbleCount - 1 && findIndex < nibbles.length - 1) {
                    int findByte;
                    int dataByte = nibbleData.get(dataIndex) << 4 | nibbleData.get(dataIndex + 1);
                    if (dataByte == (findByte = nibbles[findIndex] << 4 | nibbles[findIndex + 1])) {
                        dataIndex += 2;
                        findIndex += 2;
                        continue;
                    }
                    if (dataByte == 0 && findIndex > 0) {
                        dataIndex += 2;
                        continue;
                    }
                    differFlag = true;
                    break;
                }
                if (!differFlag && findIndex == nibbles.length) {
                    matchFlag = true;
                    HexEditor.textPanel.cursorMark = start;
                    HexEditor.textPanel.cursorDot = dataIndex;
                    break;
                }
            }
            start += byteFlag ? 2 : 1;
        }
        if (matchFlag) {
            textPanel.makeVisible(HexEditor.textPanel.cursorMark);
            textPanel.makeVisible(HexEditor.textPanel.cursorDot);
            textPanel.adjustScrollBar();
            textPanel.repaint();
        } else {
            HexEditor.showSearchMessage("Search string not found.");
        }
    }

    static void searchReplaceThis() {
        if (HexEditor.textPanel.cursorDot == HexEditor.textPanel.cursorMark) {
            HexEditor.showSearchMessage("There is no selection to replace.");
            return;
        }
        if (searchDialog == null) {
            HexEditor.showSearchMessage("There is no replacement string, no search dialog.");
            return;
        }
        String text = searchReplaceText.getText();
        if (text.length() == 0) {
            HexEditor.showSearchMessage("Replacement with an empty string is not supported.");
            return;
        }
        int[] nibbles = HexEditor.searchConvertNibbles(text, "replace");
        if (nibbles.length == 0) {
            return;
        }
        searchStatus.setText(EMPTY_STATUS);
        boolean oldFlag = overFlag;
        overFlag = false;
        HexEditor.pasteNibbles(nibbles, nibbles.length);
        overFlag = oldFlag;
    }

    static void selectAll() {
        HexEditor.textPanel.cursorDot = nibbleCount;
        HexEditor.textPanel.cursorMark = 0;
        textPanel.repaint();
    }

    static void setClipboard(String text) {
        clipString = text;
        try {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents((Transferable)((Object)userActions), null);
        }
        catch (IllegalStateException ise) {
            JOptionPane.showMessageDialog(new Frame(), "Can't put text on clipboard:\n" + ise.getMessage());
        }
    }

    static void showEditMenu(Component invoker, int x, int y) {
        boolean content = nibbleCount > 0;
        boolean selection = HexEditor.textPanel.cursorDot != HexEditor.textPanel.cursorMark;
        menuCopyDump.setEnabled(selection);
        menuCopyHex.setEnabled(selection);
        menuCopyText.setEnabled(selection);
        menuDelete.setEnabled(selection);
        menuFind.setEnabled(content);
        menuNext.setEnabled(content);
        menuReplace.setEnabled(selection);
        menuSelect.setEnabled(content);
        menuPopup.show(invoker, x, y);
    }

    static void showSearchDialog() {
        if (searchDialog == null) {
            JPanel panel1 = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 13;
            gbc.fill = 0;
            gbc.gridwidth = 1;
            panel1.add((Component)new JLabel("Search for:"), gbc);
            panel1.add(Box.createHorizontalStrut(10), gbc);
            searchFindText = new JTextField("", 20);
            searchFindText.addActionListener(userActions);
            searchFindText.setMargin(TEXT_MARGINS);
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.gridwidth = 0;
            panel1.add((Component)searchFindText, gbc);
            panel1.add(Box.createVerticalStrut(10), gbc);
            gbc.anchor = 13;
            gbc.fill = 0;
            gbc.gridwidth = 1;
            panel1.add((Component)new JLabel("Replace with:"), gbc);
            panel1.add(Box.createHorizontalStrut(10), gbc);
            searchReplaceText = new JTextField("", 20);
            searchReplaceText.addActionListener(userActions);
            searchReplaceText.setMargin(TEXT_MARGINS);
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.gridwidth = 0;
            panel1.add((Component)searchReplaceText, gbc);
            panel1.add(Box.createVerticalStrut(10), gbc);
            ButtonGroup group1 = new ButtonGroup();
            JPanel panel3 = new JPanel(new FlowLayout(1, 10, 0));
            searchIsHex = new JRadioButton("hex string", true);
            searchIsHex.setMnemonic(72);
            group1.add(searchIsHex);
            panel3.add(searchIsHex);
            searchIsText = new JRadioButton("text string", false);
            searchIsText.setMnemonic(84);
            searchIsText.addActionListener(userActions);
            group1.add(searchIsText);
            panel3.add(searchIsText);
            searchByteBound = new JCheckBox("byte boundary", false);
            searchByteBound.setMnemonic(66);
            panel3.add(searchByteBound);
            searchIgnoreNulls = new JCheckBox("ignore nulls", false);
            searchIgnoreNulls.setMnemonic(73);
            panel3.add(searchIgnoreNulls);
            gbc.anchor = 10;
            gbc.fill = 2;
            gbc.gridwidth = 0;
            panel1.add((Component)panel3, gbc);
            panel1.add(Box.createVerticalStrut(10), gbc);
            searchStatus = new JLabel(EMPTY_STATUS, 0);
            gbc.anchor = 10;
            gbc.fill = 2;
            gbc.gridwidth = 0;
            panel1.add((Component)searchStatus, gbc);
            panel1.add(Box.createVerticalStrut(16), gbc);
            JPanel panel4 = new JPanel(new FlowLayout(1, 25, 0));
            searchFindButton = new JButton("Find First");
            searchFindButton.addActionListener(userActions);
            searchFindButton.setMnemonic(70);
            panel4.add(searchFindButton);
            searchNextButton = new JButton("Find Next");
            searchNextButton.addActionListener(userActions);
            searchNextButton.setMnemonic(78);
            panel4.add(searchNextButton);
            searchReplaceButton = new JButton("Replace");
            searchReplaceButton.addActionListener(userActions);
            searchReplaceButton.setMnemonic(82);
            panel4.add(searchReplaceButton);
            searchCloseButton = new JButton("Close");
            searchCloseButton.addActionListener(userActions);
            searchCloseButton.setMnemonic(67);
            panel4.add(searchCloseButton);
            gbc.anchor = 10;
            gbc.fill = 2;
            gbc.gridwidth = 0;
            panel1.add((Component)panel4, gbc);
            JPanel panel5 = new JPanel(new FlowLayout(1, 0, 0));
            panel5.add(panel1);
            Box panel6 = Box.createVerticalBox();
            panel6.add(Box.createGlue());
            panel6.add(panel5);
            searchDialog = new JDialog((Frame)null, "Find or Replace");
            searchDialog.getContentPane().add((Component)panel6, "Center");
            searchDialog.setLocation(200, 250);
            searchDialog.setSize(500, 250);
            searchDialog.validate();
        }
        searchStatus.setText(EMPTY_STATUS);
        if (!searchDialog.isVisible()) {
            searchFindText.requestFocusInWindow();
        }
        searchDialog.setVisible(true);
    }

    static void showSearchMessage(String text) {
        if (searchDialog != null && searchDialog.isVisible()) {
            searchStatus.setText(text);
            searchDialog.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(new Frame(), text);
        }
    }

    static void userButton(ActionEvent event) {
        Object source = event.getSource();
        if (source == dumpWidthDialog) {
            dumpWidth = Integer.parseInt((String)dumpWidthDialog.getSelectedItem());
            textPanel.repaint();
        } else if (source == fontNameDialog) {
            fontName = (String)fontNameDialog.getSelectedItem();
            textPanel.repaint();
        } else if (source == menuButton) {
            HexEditor.showEditMenu(menuButton, 0, menuButton.getHeight());
        } else if (source == menuCopyDump) {
            HexEditor.copyDump();
        } else if (source == menuCopyHex) {
            HexEditor.copyHex();
        } else if (source == menuCopyText) {
            HexEditor.copyText();
        } else if (source == menuDelete) {
            HexEditor.deleteSelected();
        } else if (source == menuFind) {
            HexEditor.showSearchDialog();
        } else if (source == menuNext) {
            HexEditor.searchFindNext();
        } else if (source == menuPasteHex) {
            HexEditor.pasteHex();
        } else if (source == menuPasteText) {
            HexEditor.pasteText();
        } else if (source == menuReplace) {
            HexEditor.searchReplaceThis();
        } else if (source == menuSelect) {
            HexEditor.selectAll();
        } else if (source == openButton) {
            HexEditor.openFile(null);
            textPanel.beginFile();
        } else if (source == dumpButton) {
            HexEditor.openDump();
        } else if (source == overDialog) {
            overFlag = overDialog.isSelected();
            textPanel.repaint();
        } else if (source == saveButton) {
            HexEditor.saveFile();
        } else if (source == searchCloseButton) {
            searchDialog.setVisible(false);
        } else if (source == searchFindButton) {
            HexEditor.searchFindFirst();
        } else if (source == searchFindText) {
            HexEditor.searchFindNext();
        } else if (source == searchIsText) {
            if (searchIsText.isSelected()) {
                searchByteBound.setSelected(true);
            }
        } else if (source == searchNextButton) {
            HexEditor.searchFindNext();
        } else if (source == searchReplaceButton) {
            HexEditor.searchReplaceThis();
        } else if (source == searchReplaceText) {
            HexEditor.searchReplaceThis();
        } else {
            System.err.println("Error in HexEdit1 userButton(): ActionEvent not recognized: " + event);
        }
    }

    public static void openDump() {
        CPC.dump();
        HexEditor.openFile(new File("output.bin"));
        textPanel.beginFile();
    }

    public static void main(String[] args) {
        new HexEditor();
    }

    static {
        DUMP_WIDTHS = new String[]{"4", "8", "12", "16", "24", "32"};
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        MARKER_STRING = Character.toString('|');
        TEXT_MARGINS = new Insets(2, 3, 2, 3);
    }
}

